﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Shoping.order
{
    public partial class shopingcart : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Request.Params["bookID"] != null)
                {
                    //设置商品的属性
                    cartProduct product = new cartProduct();
                    int bookID = Int32.Parse(Request.Params["bookID"].ToString());
                    product.BookID = bookID;
                    product.Name = Request.Params["name"].ToString();
                    product.Price = Request.Params["price"].ToString();
                    product.Number = 1;
                    ///添加商品到购物车
                    cart shoppingCart = new cart();
                    if (shoppingCart.AddProductToShoppingCart(product) > -1)
                    {
                        Response.Write("<script language=javascript>alert('恭喜您，添加商品到购物车成功！');</script>");
                        product = null;
                    }
                }
                dataCart();
            }
        }
        public void dataCart()
        {
            ///获取购物车的商品
            cart shoppingCart = new cart();

            ///绑定数据并显示商品
            gvProduct.DataSource = shoppingCart.BookList;
            gvProduct.DataBind();

            btCreate.Enabled = btUpdate.Enabled = gvProduct.Rows.Count > 0 ? true : false;
        }



        protected void gvProduct_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            ///获取购物车的商品
            cart shoppingCart = new cart();
            if (shoppingCart == null || shoppingCart.BookList == null || shoppingCart.BookList.Count <= 0) return;
            ///创建被删除的商品
            cartProduct deleteProduct = new cartProduct();
            deleteProduct.BookID = Int32.Parse(e.CommandArgument.ToString());
            ///删除选中的商品
            shoppingCart.DeleteProductFromShoppingCart(deleteProduct);
            ///重新绑定商品数据
            dataCart();
        }
        protected void btUpdate_Click(object sender, EventArgs e)
        {
            ///获取购物车的商品
            cart shoppingCart = new cart();
            if (shoppingCart == null || shoppingCart.BookList == null || shoppingCart.BookList.Count <= 0) return;
            ///检查购物车中的商品和显示的商品是否相等，如果不相等，则数据错误。
            if (shoppingCart.BookList.Count != gvProduct.Rows.Count) return;

            ArrayList products = new ArrayList();
            foreach (GridViewRow row in gvProduct.Rows)
            {   ///找到输入商品数量的控件
                TextBox tbNumber = (TextBox)row.FindControl("tbNumber");
                if (tbNumber == null) return;
                ///获取商品数量
                int number = -1;
                if (Int32.TryParse(tbNumber.Text.Trim(), out number) == false) return;
                ///创建一个子项，并添加到临时数组中
                cartProduct product = new cartProduct();
                ///设置子项的名称、数量、价格和商品ID值
                product.Name = ((cartProduct)shoppingCart.BookList[row.RowIndex]).Name;
                product.Number = number;
                product.Price = ((cartProduct)shoppingCart.BookList[row.RowIndex]).Price;
                product.BookID = ((cartProduct)shoppingCart.BookList[row.RowIndex]).BookID;
                products.Add(product);
            }
            ///修改购物车中的商品数量
            shoppingCart.UpdateProductFromShoppingCart(products);
        }
        protected void btCreate_Click(object sender, EventArgs e)
        {
            Response.Redirect("createOrder.aspx");
        }
        protected void btBuy_Click(object sender, EventArgs e)
        {
            Response.Redirect("../Default.aspx");
        }
    }
}