﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Shoping.UserControls
{
    public partial class BookList : System.Web.UI.UserControl
    {
        protected int firstId = -1;
        protected int secondId = -1;
        //创建一个分页数据源对象
        static PagedDataSource pds = new PagedDataSource();

        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.Params["firstId"] != null)
            {
                firstId = Int32.Parse(Request.Params["firstId"].ToString());
            }
            if (Request.Params["secondId"] != null)
            {
                secondId = Int32.Parse(Request.Params["secondId"].ToString());
            }
            if (!IsPostBack)
            {
                databind(0);
            }
        }
        /// <summary>
        /// 绑定分类菜单
        /// </summary>
        public void databind(int pageNo)
        {
            string sql;
            if (secondId != -1)//按照二级分类进行图书过滤
            {
                sql = "select * from [product] where className in(select  name from [classes] where Id=" + secondId + ") order by CreateDate desc";
            }
            else if (firstId != -1)//按照一级分类进行图书过滤
            {
                sql = "select * from [product] where className in(select  name from [classes] where parentId=" + firstId + ") order by CreateDate desc";
            }
            else//首次打开，显示所有图书
            {
                sql = "select * from [product] order by CreateDate desc";
            }
            pds.AllowPaging = true;//允许分页
            pds.PageSize = 6;//每页显示2条记录
            pds.CurrentPageIndex = pageNo;//设置当前页

            DataTable table = DataBase.ExecuteDataTable(sql, CommandType.Text, null);
            if (table == null)
            {
                Label1.Visible = true;
                Label1.Text = "对不起，没有这方面的书籍！";
                return;
            }
            Label1.Visible = false;
            pds.DataSource = table.DefaultView;
            DataList1.DataSource = pds;
            DataList1.DataBind();

        }
        protected void DataList1_ItemDataBound(object sender, DataListItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Footer)
            {
                //获取脚模板中的控件
                Label curPage = e.Item.FindControl("lblCurrentPage") as Label;
                Label pageCount = e.Item.FindControl("lblPageCount") as Label;
                LinkButton firstPage = e.Item.FindControl("lbFirst") as LinkButton;
                LinkButton priorPage = e.Item.FindControl("lbPrior") as LinkButton;
                LinkButton nextPage = e.Item.FindControl("lbNext") as LinkButton;
                LinkButton lastPage = e.Item.FindControl("lbLast") as LinkButton;
                //设置当前页和总页数
                curPage.Text = (pds.CurrentPageIndex + 1).ToString();
                pageCount.Text = pds.PageCount.ToString();
                //设置首页和上一页是否可用
                if (pds.IsFirstPage)
                {
                    firstPage.Enabled = false;
                    priorPage.Enabled = false;
                }
                //设置下一页和尾页是否可用
                if (pds.IsLastPage)
                {
                    nextPage.Enabled = false;
                    lastPage.Enabled = false;
                }
            }

        }
        protected void DataList1_ItemCommand(object source, DataListCommandEventArgs e)
        {
            switch (e.CommandName)
            {
                case "first"://首页
                    pds.CurrentPageIndex = 0;
                    databind(pds.CurrentPageIndex);
                    break;
                case "prior"://上一页
                    pds.CurrentPageIndex--;
                    databind(pds.CurrentPageIndex);
                    break;
                case "next"://下一页
                    pds.CurrentPageIndex++;
                    databind(pds.CurrentPageIndex);
                    break;
                case "last"://尾页
                    pds.CurrentPageIndex = pds.PageCount - 1;
                    databind(pds.CurrentPageIndex);
                    break;
                case "go"://跳转到指定页
                    if (e.Item.ItemType == ListItemType.Footer)
                    {
                        TextBox txtPage = e.Item.FindControl("txtPage") as TextBox;
                        int pageCount = pds.PageCount;//总页数
                        int pageNo = 0;
                        //读取用户输入的页数
                        if (!txtPage.Text.Equals(""))
                        {
                            pageNo = Convert.ToInt32(txtPage.Text.ToString());
                        }
                        if (pageNo <= 0 || pageNo > pageCount)//判断数据是否合法
                        {
                            Response.Write("<script>alert('请输入正确的页数！')</script>");
                        }
                        else
                        {
                            databind(pageNo - 1);//跳转
                        }
                    }
                    break;
            }

        }
    }
}