﻿using System;
using System.Data;
using System.Collections;
using System.Configuration;
using System.Data.SqlClient;
using System.Web;
using System.Web.SessionState;

/// <summary>
/// 购物车
/// </summary>
public class cart
{
	public const string SHOPPINTCARTDATAKEY = "SHOPPINTCARTDATAKEY";
	private ArrayList bookList;		

	public ArrayList BookList
	{
		get
		{
			return bookList;
		}
	}

	/// <summary>
	/// 购物车初始化
	/// </summary>		
	public cart()
	{   ///判断Session是否为空
		if(HttpContext.Current.Session != null)
		{   ///获取购物车的信息
			if(HttpContext.Current.Session[SHOPPINTCARTDATAKEY] != null)
			{
				bookList = (ArrayList)HttpContext.Current.Session[SHOPPINTCARTDATAKEY];
			}
			else
			{   ///如果为空，则创建新的购物车列表
				bookList = new ArrayList();
				HttpContext.Current.Session[SHOPPINTCARTDATAKEY] = bookList;
			}
		}
	}

	/// <summary>
	/// 向购物车中的添加商品
	/// </summary>
	/// <param name="product"></param>
	/// <returns></returns>
	public int AddProductToShoppingCart(cartProduct product)
	{
		if(product == null) return -1;
		///获取购物车中的商品
		bookList = (ArrayList)HttpContext.Current.Session[SHOPPINTCARTDATAKEY];
		if(bookList == null) return -1;

		///比较购物车中是否已经存在该商品
		int index = 0;
		for(index = 0; index < bookList.Count; index++)
		{   ///如果已经存在，则修改购物车中该商品的数量
			if(((cartProduct)bookList[index]).BookID == product.BookID)
			{
				((cartProduct)bookList[index]).Number++;
				break;
			}
		}
		///如果不存在，则把该商品添加到购物车中
		if(index == bookList.Count)
		{
			bookList.Add(product);
		}
		///重新保存购物车中的数据
		HttpContext.Current.Session[SHOPPINTCARTDATAKEY] = bookList;
		return 1;
	}

	/// <summary>
	/// 更新购物车中的商品
	/// </summary>
	/// <param name="products"></param>
	/// <returns></returns>
	public int UpdateProductFromShoppingCart(ArrayList products)
	{
		if(products == null || products.Count <= 0) return -1;
		///获取购物车中的商品
		bookList = (ArrayList)HttpContext.Current.Session[SHOPPINTCARTDATAKEY];
		if(bookList == null) return -1;
		///更新购物车中的商品
		for(int index = 0; index < bookList.Count; index++)
		{
			foreach(cartProduct product in products)
			{
				if(((cartProduct)bookList[index]).BookID == product.BookID)
				{   ///修改商品的数量
					((cartProduct)bookList[index]).Number = product.Number;
					break;
				}
			}
		}

		///重新保存购物车中的数据
		HttpContext.Current.Session[SHOPPINTCARTDATAKEY] = bookList;
		return 1;
	}

	/// <summary>
	/// 删除购物车中的商品
	/// </summary>
	/// <param name="product"></param>
	/// <returns></returns>
	public int DeleteProductFromShoppingCart(cartProduct product)
	{
		if(product == null) return -1;
		///获取购物车中的商品
		bookList = (ArrayList)HttpContext.Current.Session[SHOPPINTCARTDATAKEY];
		if(bookList == null) return -1;

		///从购物车查找被删除的商品
		foreach(cartProduct item in bookList)
		{
			if(item.BookID == product.BookID)
			{   ///移除该商品
				bookList.Remove(item);
				break;
			}
		}
		///重新保存购物车中的数据
		HttpContext.Current.Session[SHOPPINTCARTDATAKEY] = bookList;
		return 1;
	}		

	/// <summary>
	/// 清空购物车中的商品
	/// </summary>
	/// <returns></returns>
	public int ClearShoppingCart()
	{	///获取购物车中的商品
		bookList = (ArrayList)HttpContext.Current.Session[SHOPPINTCARTDATAKEY];
		if(bookList == null) return -1;
		///清空购物车中的商品
		bookList.Clear();
		HttpContext.Current.Session[SHOPPINTCARTDATAKEY] = null;
		return 1;
	}
}
