﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;


using System.Collections;
using System.Data.SqlClient;

/// <summary>
///DataBase 的摘要说明
/// </summary>
public class DataBase
{
	public DataBase()
	{
		//
		//TODO: 在此处添加构造函数逻辑
		//
	}
    private static readonly string ConnString = ConfigurationManager.ConnectionStrings["shoping"].ConnectionString;
    #region 私有函数

    private static void AddParameters(ref SqlCommand cmd, Hashtable htParms)
    {
        IDictionaryEnumerator de = htParms.GetEnumerator();
        // 作哈希表循环
        while (de.MoveNext())
        {
            cmd.Parameters.Add(new SqlParameter("@" + de.Key.ToString(), de.Value));
        }
    }

    #endregion
    /// <summary>
    /// 执行Trasact-SQL语句并返回受影响的行数
    /// </summary>
    /// <param name="cmdText">Trasact-SQL语句或存储过程</param>
    /// <param name="cmdType">Trasact-SQL语句的类型</param>
    /// <param name="htParms">参数哈希</param>
    public static int ExecuteNonQuery(string cmdText, CommandType cmdType, Hashtable htParms)
    {
        using (SqlConnection conn = new SqlConnection(ConnString))
        {
            SqlCommand cmd = new SqlCommand(cmdText, conn);
            cmd.CommandType = cmdType;
            if (htParms != null && htParms.Count > 0)
            {
                AddParameters(ref cmd, htParms);
            }
            conn.Open();
            int result = cmd.ExecuteNonQuery();
            cmd.Dispose();
            conn.Close();
            return result;
        }
    }

    /// <summary>
    /// 执行查询并返回结果集中第1行的第1列
    /// </summary>
    /// <param name="cmdText">Trasact-SQL语句或存储过程</param>
    /// <param name="cmdType">Trasact-SQL语句的类型</param>
    /// <param name="htParms">参数哈希</param>
    public static object ExecuteScalar(string cmdText, CommandType cmdType, Hashtable htParms)
    {
        using (SqlConnection conn = new SqlConnection(ConnString))
        {
            SqlCommand cmd = new SqlCommand(cmdText, conn);
            cmd.CommandType = cmdType;
            if (htParms != null && htParms.Count > 0)
            {
                AddParameters(ref cmd, htParms);
            }
            conn.Open();
            object result = cmd.ExecuteScalar();
            cmd.Dispose();
            conn.Close();
            return result;
        }
    }
    /// <summary>
    /// 返回一行数据中的各个字段
    /// </summary>
    /// <param name="sql"></param>
    /// <returns></returns>
    public static SqlDataReader ExecuteReader(string sql)
    {

        SqlConnection conn = new SqlConnection(ConnString);
        SqlCommand cmd = new SqlCommand(sql, conn);
        conn.Open();
        try
        {
            SqlDataReader rdr = cmd.ExecuteReader(CommandBehavior.CloseConnection);//返回选择集对象///CommandBehavior.CloseConnection数据库使用完毕关闭数据库

            return rdr;
        }
        catch
        {
            conn.Close();
            throw;
        }
    }
    /// <summary>
    /// 执行查询返回数据表
    /// </summary>
    /// <param name="cmdText">Trasact-SQL语句或存储过程</param>
    /// <param name="cmdType">Trasact-SQL语句的类型</param>
    /// <param name="htParms">参数哈希</param>
    public static DataTable ExecuteDataTable(string cmdText, CommandType cmdType, Hashtable htParms)
    {
        using (SqlConnection conn = new SqlConnection(ConnString))
        {
            SqlCommand cmd = new SqlCommand(cmdText, conn);
            cmd.CommandType = cmdType;
            if (htParms != null && htParms.Count > 0)
            {
                AddParameters(ref cmd, htParms);
            }
            DataTable dt = new DataTable();
            conn.Open();
            SqlDataReader dr = cmd.ExecuteReader();
            if (dr.HasRows)
            {
                for (int i = 0; i < dr.FieldCount; i++)
                {
                    dt.Columns.Add(dr.GetName(i), dr.GetFieldType(i));
                }
                object[] values = new object[dr.FieldCount];
                while (dr.Read())
                {
                    dr.GetValues(values);
                    dt.Rows.Add(values);
                }
            }
            else
            {
                dt = null;
            }
            dr.Close();
            conn.Close();
            return dt;
        }
    }
    /// <summary>
    /// 
    /// </summary>
    /// <param name="SqlString"></param>
    /// <returns></returns>
    //public static SqlDataAdapter ExeAdapter(String sql)
    //{
    //    SqlConnection conn = new SqlConnection(ConnString);
    //    conn.Open();
    //    try
    //    {
    //        SqlDataAdapter adapter = new SqlDataAdapter(sql, conn);
    //        return adapter;
    //    }
    //    catch
    //    {
    //        conn.Close();
    //        throw;
    //    }

    //}
    /// <summary>
    /// 上传文件图片文件
    /// </summary>
    /// <param name="FileUpload1">上传控件的名称</param>
    /// <param name="savePath">文件保存的绝对路径</param>
    /// <returns>返回fileName：上传失败时,值为0；成功时,值为生成的文件名</returns>
    public static string UploadPic(ref FileUpload FileUpload1, string savePath)
    {
        string fileExt, fileName, newFileName = "0", filePath = savePath;
        fileName = FileUpload1.FileName.Trim();
        if (fileName != "")
        {
            int j = fileName.LastIndexOf('.');
            fileExt = fileName.Substring(j).ToLower();
            if (fileExt == ".bmp" || fileExt == ".jpg" || fileExt == ".gif" || fileExt == ".png")
            {
                Random r = new Random();
                int i = r.Next(0, 1000);
                newFileName = DateTime.Now.ToString("yyyyMMddHHmmss") + i.ToString() + fileExt;
                filePath += newFileName;
                FileUpload1.SaveAs(filePath);
            }
        }
        return newFileName;
    }
}
