﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
namespace GridViewDemo
{
    public partial class BoundField : System.Web.UI.Page
    {
        SqlConnection sqlcon; //定义连接对象
        SqlCommand sqlcom; //定义命令对象，为后面运行SQL语句
        string strCon = System.Web.Configuration.WebConfigurationManager.ConnectionStrings["pubsConnectionString"].ConnectionString;

        //定义数据绑定方法
        public void bind()
        {            
            sqlcon = new SqlConnection(strCon);//实例化数据连接对象
            //创建数据操作适配器对象
            SqlDataAdapter myda = new SqlDataAdapter("select * from authors", sqlcon); 
            DataSet myds = new DataSet(); //创建数据集            
            myda.Fill(myds, "authors"); //将取得的数据填充到数据集当中
            DataView view = myds.Tables["authors"].DefaultView;
            string sort = (string)ViewState["SortOrder"] + " " +(string)ViewState["OrderDire"];
            view.Sort = sort;
            GridView1.DataSource = view; //为GridView指名数据源
            GridView1.DataKeyNames = new string[] { "au_id" };
            //为GridView控件当中数据指名关键字，以便于在后面更新数据时得以应用。
            GridView1.DataBind(); //数据绑定            
        }
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                ViewState["SortOrder"] = "au_id";
                ViewState["OrderDire"] = "ASC";
                bind();//实现数据绑定
            }
        }

        protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
        {
            GridView1.EditIndex = e.NewEditIndex; //设定GridView控件当前数据行处于编辑状态
            bind(); //数据绑定
        }

        protected void GridView1_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            sqlcon = new SqlConnection(strCon); //创建数据库连接对象
            string sqlstr = "update authors set au_lname = '"+ ((TextBox)(GridView1.Rows[e.RowIndex].Cells[1].Controls[0])).Text.ToString().Trim() 
                + "', au_fname = '" + ((TextBox)(GridView1.Rows[e.RowIndex].Cells[2].Controls[0])).Text.ToString().Trim() 
                + "', contract = '" + ((CheckBox)(GridView1.Rows[e.RowIndex].Cells[3].Controls[0])).Checked 
                + "' where au_id = '" + GridView1.DataKeys[e.RowIndex].Value.ToString() + "'";
            sqlcom = new SqlCommand(sqlstr, sqlcon); //创建数据操作命令对象
            sqlcon.Open();//打开数据库
            sqlcom.ExecuteNonQuery(); //执行SQL语句命令
            sqlcon.Close(); //关闭数据库连接
            GridView1.EditIndex = -1; //将GridView控件当前的编辑状态取消
            bind(); //重新数据绑定
        }

        protected void GridView1_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            GridView1.EditIndex = -1; //将GridView控件当前的编辑状态取消
            bind(); //重新数据绑定
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            string sqlstr = "delete from authors where au_id = '" + GridView1.DataKeys[e.RowIndex].Value.ToString() + "'";
            sqlcon = new SqlConnection(strCon); //创建数据库连接
            sqlcom = new SqlCommand(sqlstr, sqlcon); //使用数据命令对象以便于执行上面的SQL语句
            sqlcon.Open();//打开数据库连接
            sqlcom.ExecuteNonQuery(); //执行SQL命令
            sqlcon.Close();//关闭数据库连接
            bind(); //重新数据绑定
        }

        protected void GridView1_Sorting(object sender, GridViewSortEventArgs e)
        {
            string sPage = e.SortExpression;
            if (ViewState["SortOrder"].ToString() == sPage)
            {
                if (ViewState["OrderDire"].ToString() == "Desc")
                ViewState["OrderDire"] = "ASC";
            else
                ViewState["OrderDire"] = "Desc";
            }
            else
            {
                ViewState["SortOrder"] = e.SortExpression;
            }
            bind();
        }

        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView1.PageIndex = e.NewPageIndex;            
            bind();
        }
    }
}