﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
namespace DataListDemo
{
    public partial class DataListDemo : System.Web.UI.Page
    {
        SqlConnection sqlcon; //定义连接对象
        SqlCommand sqlcom; //定义命令对象，为后面运行SQL语句
        string strCon = System.Web.Configuration.WebConfigurationManager.ConnectionStrings["pubsConnectionString"].ConnectionString;
        //创建一个分页数据源对象
        static PagedDataSource pds = new PagedDataSource();
        //定义数据绑定方法
        public void bind(int pageNo)
        {
            pds.AllowPaging = true;//允许分页
            pds.PageSize = 2;//每页显示2条记录
            pds.CurrentPageIndex = pageNo;//设置当前页
            sqlcon = new SqlConnection(strCon);//实例化数据连接对象
            //创建数据操作适配器对象
            SqlDataAdapter myda = new SqlDataAdapter("select * from authors", sqlcon);
            DataSet myds = new DataSet(); //创建数据集            
            myda.Fill(myds, "authors"); //将取得的数据填充到数据集当中
            pds.DataSource = myds.Tables["authors"].DefaultView;
            DataList1.DataSource = pds; //为GridView指名数据源
            DataList1.DataBind(); //数据绑定            
        }
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {                
                bind(0);//实现数据绑定
            }
        }

        protected void DataList1_ItemDataBound(object sender, DataListItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Footer)
            {
                //获取脚模板中的控件
                Label curPage = e.Item.FindControl("lblCurrentPage") as Label;
                Label pageCount = e.Item.FindControl("lblPageCount") as Label;
                LinkButton firstPage = e.Item.FindControl("lbFirst") as LinkButton;
                LinkButton priorPage = e.Item.FindControl("lbPrior") as LinkButton;
                LinkButton nextPage = e.Item.FindControl("lbNext") as LinkButton;
                LinkButton lastPage = e.Item.FindControl("lbLast") as LinkButton;
                //设置当前页和总页数
                curPage.Text = (pds.CurrentPageIndex + 1).ToString();
                pageCount.Text = pds.PageCount.ToString();
                //设置首页和上一页是否可用
                if (pds.IsFirstPage)
                {
                    firstPage.Enabled = false;
                    priorPage.Enabled = false;
                }
                //设置下一页和尾页是否可用
                if (pds.IsLastPage)
                {
                    nextPage.Enabled = false;
                    lastPage.Enabled = false;
                }
            }            
        }

        protected void DataList1_ItemCommand(object source, DataListCommandEventArgs e)
        {
            switch (e.CommandName)
            {
                case "first"://首页
                    pds.CurrentPageIndex = 0;
                    bind(pds.CurrentPageIndex);
                    break;
                case "prior"://上一页
                    pds.CurrentPageIndex--;
                    bind(pds.CurrentPageIndex);
                    break;
                case "next"://下一页
                    pds.CurrentPageIndex++;
                    bind(pds.CurrentPageIndex);
                    break;
                case "last"://尾页
                    pds.CurrentPageIndex = pds.PageCount-1;
                    bind(pds.CurrentPageIndex);
                    break;
                case "go"://跳转到指定页
                    if (e.Item.ItemType == ListItemType.Footer)
                    {
                        TextBox txtPage = e.Item.FindControl("txtPage") as TextBox;
                        int pageCount = pds.PageCount;//总页数
                        int pageNo = 0;
                        //读取用户输入的页数
                        if (!txtPage.Text.Equals(""))
                        {
                            pageNo = Convert.ToInt32(txtPage.Text.ToString());
                        }
                        if (pageNo <= 0 || pageNo > pageCount)//判断数据是否合法
                        {
                            Response.Write("<script>alert('请输入正确的页数！')</script>");
                        }
                        else
                        {
                            bind(pageNo - 1);//跳转
                        }
                    }                        
                    break;
            }
        }
    }
}