﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
public partial class DataAdapterDemo : System.Web.UI.Page
{
    private SqlDataAdapter adapter;
    private DataSet myDs;
    protected void Page_Load(object sender, EventArgs e)
    {
        //连接字符串
        String sqlconn = "Data Source = .;Initial Catalog = pubs; Integrated Security = True;";
        SqlConnection myConnection = new SqlConnection(sqlconn);
        adapter = new SqlDataAdapter("select * from authors", myConnection);
        SqlCommandBuilder but = new SqlCommandBuilder(adapter);
        myDs = new DataSet();
        adapter.Fill(myDs, "auth");//将数据填充到数据集
        //为表auth添加主键
        myDs.Tables[0].PrimaryKey = new DataColumn[] { myDs.Tables[0].Columns[0] };
        GridView1.DataSource = myDs.Tables[0].DefaultView;  //数据库控件指定数据源
        GridView1.DataBind(); //进行数据邦定
        if (!IsPostBack)
        {
            TextBox1.Text = (string)myDs.Tables[0].Rows[0][0];
            TextBox2.Text = (string)myDs.Tables[0].Rows[0][1];
            TextBox3.Text = (string)myDs.Tables[0].Rows[0][2];
        }            
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        //修改第一条记录        
        myDs.Tables[0].Rows[0][0] = this.TextBox1.Text;
        myDs.Tables[0].Rows[0][1] = this.TextBox2.Text;
        myDs.Tables[0].Rows[0][2] = this.TextBox3.Text;
        adapter.Update(myDs,"auth");
        //刷新数据显示
        GridView1.DataSource = myDs.Tables[0].DefaultView;  //数据库控件指定数据源
        GridView1.DataBind(); //进行数据邦定
    }

    protected void Button2_Click(object sender, EventArgs e)
    {
        //新增记录
        DataRow row = myDs.Tables[0].NewRow();//RowState为Detached
        //为所有的非空列赋值
        row[0] = TextBox1.Text;
        row[1] = TextBox2.Text;
        row[2] = TextBox3.Text;
        row[8] = true;
        myDs.Tables[0].Rows.Add(row);//RowState为Added
        adapter.Update(myDs, "auth");
        //刷新数据显示
        GridView1.DataSource = myDs.Tables[0].DefaultView;  //数据库控件指定数据源
        GridView1.DataBind(); //进行数据邦定
    }

    protected void Button3_Click(object sender, EventArgs e)
    {
        //删除记录
        //第一种方法：使用Find方法查找，要求表auth要有主键
        DataRow row;
        row = myDs.Tables[0].Rows.Find(TextBox1.Text);
        row.Delete();
        //第二种方法：使用Select方法查找，返回一个数组
        //DataRow[] rows = myDs.Tables[0].Select("au_id='" + TextBox1.Text+"'");
        //if (rows.Length==0) return;
        //rows[0].Delete();
        adapter.Update(myDs, "auth");
        //刷新数据显示
        GridView1.DataSource = myDs.Tables[0].DefaultView;  //数据库控件指定数据源
        GridView1.DataBind(); //进行数据邦定
    }
}