﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Optimization;
using System.Web.Routing;
using System.Web.Security;
using System.Web.SessionState;

namespace Ex_Application
{
    public class Global : HttpApplication
    {
        void Application_Start(object sender, EventArgs e)
        {
            // 在应用程序启动时运行的代码
            RouteConfig.RegisterRoutes(RouteTable.Routes);
            BundleConfig.RegisterBundles(BundleTable.Bundles);
            Application["count"] = 0;
        }
        void Session_Start(object sender, EventArgs e)
        {
            // 在新会话启动时运行的代码
            Application.Lock();
            Application["count"] = (int)Application["count"] + 1;
            Application.UnLock();
        }
        void Session_End(object sender, EventArgs e)
        {
            // 在会话结束时运行的代码。 
            // 注意: 只有在 Web.config 文件中的 sessionstate 模式设置为InProc 时，才会引发
            // Session_End 事件。如果会话模式设置为 StateServer或 SQLServer，则不会引发该事件。
            Application.Lock();
            Application["count"] = (int)Application["count"] - 1;
            Application.UnLock();
        }
    }
}