﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace abstracts
{
    abstract public class Window
    {   // Window为抽象类
        public Window(int top, int left)
        { this.top = top; this.left = left; }
        abstract public void DrawWindow();  // DrawWindow方法为抽象方法
        protected int top;
        protected int left;
    }
    public class ListBox : Window
    {
        public ListBox(int top, int left, string contents) : base(top, left)
        { listBoxContents = contents; } //调用基类的构造函数   
        public override void DrawWindow()
        { Console.WriteLine("Writing string to the listbox: {0}", listBoxContents); }
        private string listBoxContents;
    }
    public class Tester
    {
        static void Main()
        {
            Window[] winArray = new Window[3];
            winArray[0] = new ListBox(1, 2, "First List Box");
            winArray[1] = new ListBox(3, 4, "Second List Box");
            for (int i = 0; i < 2; i++)
            { winArray[i].DrawWindow(); }
            Console.ReadKey(); //让程序在输出结果后暂停，以便查看输出结果
        }
    }
}
